
<?php $__env->startSection('title','Hotspot Profiles — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:14px;gap:12px;flex-wrap:wrap">
    <div>
      <h1 style="margin:0 0 4px">Hotspot Profiles</h1>
      <div class="muted">All <code>/ip hotspot user profile</code> on your MikroTik routers.</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
      <form method="get" action="<?php echo e(route('hotspot.profiles.index')); ?>">
        <select class="input" name="router_id" onchange="this.form.submit()">
          <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($r->id); ?>" <?php if($routerId == $r->id): echo 'selected'; endif; ?>><?php echo e($r->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </form>

      <?php if($router): ?>
        <a href="<?php echo e(route('hotspot.profiles.create',['router_id'=>$router->id])); ?>"
           class="btn" style="text-decoration:none">+ New Profile</a>
      <?php endif; ?>
    </div>
  </div>

  <?php if(session('status')): ?>
    <div class="card full" style="margin-bottom:12px;border-left:3px solid var(--bb-green)">
      <?php echo e(session('status')); ?>

    </div>
  <?php endif; ?>

  <div class="card full">
    <?php if($router && !empty($profiles)): ?>
      <table>
        <thead>
          <tr>
            <th>Name</th>
            <th>Rate limit</th>
            <th>Shared users</th>
            <th>Idle timeout</th>
            <th>Keepalive</th>
            <th>Parent queue</th>
            <th>Comment</th>
            <th style="width:120px;text-align:right">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><?php echo e($p['name']); ?></td>
              <td><?php echo e($p['rate_limit'] ?? '—'); ?></td>
              <td><?php echo e($p['shared_users'] ?? '—'); ?></td>
              <td><?php echo e($p['idle_timeout'] ?? '—'); ?></td>
              <td><?php echo e($p['keepalive_timeout'] ?? '—'); ?></td>
              <td><?php echo e($p['parent_queue'] ?? '—'); ?></td>
              <td class="muted"><?php echo e($p['comment'] ?? '—'); ?></td>
              <td style="text-align:right">
                <a href="<?php echo e(route('hotspot.profiles.edit',[$router->id,$p['name']])); ?>"
                   class="btn-ghost" style="padding:4px 8px;font-size:12px">Edit</a>
                <form method="POST"
                      action="<?php echo e(route('hotspot.profiles.destroy',[$router->id,$p['name']])); ?>"
                      style="display:inline"
                      onsubmit="return confirm('Delete this profile from MikroTik?')">
                  <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                  <button class="btn-ghost" style="padding:4px 8px;font-size:12px;color:#ef4444">
                    Delete
                  </button>
                </form>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    <?php else: ?>
      <div class="muted">No profiles found or router not reachable.</div>
    <?php endif; ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/hotspot/profiles/index.blade.php ENDPATH**/ ?>