
<?php $__env->startSection('title','Edit Plan — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <h1 style="margin:0 0 12px">Edit Plan</h1>

  <div class="card full">
    <form method="POST" action="<?php echo e(route('plans.update',$plan)); ?>">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PUT'); ?>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id">
            <option value="">All routers / generic</option>
            <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($router->id); ?>" <?php if($plan->router_id == $router->id): echo 'selected'; endif; ?>>
                <?php echo e($router->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="<?php echo e($plan->name); ?>" required>
        </div>

        <div>
          <label class="label">Profile (MikroTik)</label>
          <input class="input" name="profile" value="<?php echo e($plan->profile); ?>">
        </div>

        <div>
          <label class="label">Validity (hours)</label>
          <input class="input" type="number" name="validity_hours"
                 value="<?php echo e($plan->validity_hours); ?>" required>
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" value="<?php echo e($plan->rate_limit); ?>">
        </div>

        <div>
          <label class="label">Download limit (MB)</label>
          <input class="input" type="number" name="download_limit_mb"
                 value="<?php echo e($plan->download_limit_mb); ?>">
        </div>

        <div>
          <label class="label">Upload limit (MB)</label>
          <input class="input" type="number" name="upload_limit_mb"
                 value="<?php echo e($plan->upload_limit_mb); ?>">
        </div>

        <div>
          <label class="label">Price (TZS)</label>
          <input class="input" type="number" name="price"
                 value="<?php echo e($plan->price); ?>" required>
        </div>

        <div>
          <label class="label">Currency</label>
          <input class="input" name="currency" value="<?php echo e($plan->currency); ?>">
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="is_active">
            <option value="1" <?php if($plan->is_active): echo 'selected'; endif; ?>>Active</option>
            <option value="0" <?php if(!$plan->is_active): echo 'selected'; endif; ?>>Disabled</option>
          </select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="<?php echo e(route('plans.index')); ?>" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Update Plan</button>
      </div>
    </form>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/plans/edit.blade.php ENDPATH**/ ?>