
<?php $__env->startSection('title','New Voucher — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <h1 style="margin:0 0 12px">New Voucher (Agent / Cash)</h1>

  <div class="card full">
    <form method="POST" action="<?php echo e(route('vouchers.store')); ?>">
      <?php echo csrf_field(); ?>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id" required>
            <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($router->id); ?>" <?php if(old('router_id')==$router->id): echo 'selected'; endif; ?>>
                <?php echo e($router->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div>
          <label class="label">Plan</label>
          <select class="input" name="plan_id" required>
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($plan->id); ?>" <?php if(old('plan_id')==$plan->id): echo 'selected'; endif; ?>>
                <?php echo e($plan->name); ?> — <?php echo e(number_format($plan->price)); ?> <?php echo e($plan->currency); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div>
          <label class="label">Buyer phone (optional)</label>
          <input class="input" name="buyer_phone"
                 value="<?php echo e(old('buyer_phone')); ?>" placeholder="2557xxxxxxxx">
        </div>

        <div style="display:flex;align-items:center;gap:8px;margin-top:22px">
          <input type="checkbox" id="send_sms" name="send_sms" value="1"
                 <?php if(old('send_sms',1)): echo 'checked'; endif; ?>>
          <label for="send_sms" class="muted" style="font-size:13px">
            Send voucher via SMS (Beem)
          </label>
        </div>

      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="<?php echo e(route('vouchers.index')); ?>" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Generate Voucher</button>
      </div>
    </form>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/vouchers/create.blade.php ENDPATH**/ ?>