<?php $__env->startSection('title','Vouchers — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px">
    <div>
      <h1 style="margin:0 0 4px">Vouchers</h1>
      <div class="muted">List of generated vouchers.</div>
    </div>

    <a href="<?php echo e(route('vouchers.create')); ?>" class="btn" style="text-decoration:none">
      + New Voucher
    </a>
  </div>

  <div class="card full">
    <?php if($vouchers->count()): ?>
      <table>
        <thead>
        <tr>
          <th>Code</th>
          <th>Router</th>
          <th>Plan</th>
          <th>Price</th>
          <th>Status</th>
          <th>Buyer</th>
          <th>Created</th>
          <th>By</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><strong><?php echo e($v->code); ?></strong></td>
            <td><?php echo e($v->router?->name ?? '—'); ?></td>
            <td><?php echo e($v->plan?->name ?? '—'); ?></td>
            <td><?php echo e(number_format($v->price)); ?> <?php echo e($v->currency); ?></td>
            <td>
              <?php
                $cls = match($v->status){
                    'active' => 'paid',
                    'pending' => 'pending',
                    'used','expired','cancelled' => 'failed',
                    default => ''
                };
              ?>
              <span class="status <?php echo e($cls); ?>"><?php echo e(ucfirst($v->status)); ?></span>
            </td>
            <td><?php echo e($v->buyer_phone ?: '—'); ?></td>
            <td class="muted"><?php echo e($v->created_at->format('Y-m-d H:i')); ?></td>
            <td><?php echo e($v->creator?->name ?? '—'); ?></td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>

      <div style="margin-top:10px">
        <?php echo e($vouchers->links()); ?>

      </div>
    <?php else: ?>
      <div class="muted">No vouchers yet.</div>
    <?php endif; ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/vouchers/index.blade.php ENDPATH**/ ?>