
<?php $__env->startSection('title','My Sales — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">My Sales</h1>
      <div class="muted">All orders where you are the freelancer.</div>
    </div>
  </div>

  <div class="card full">
    <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:10px">
      <div>
        <label class="label">From</label>
        <input class="input" type="date" name="from" value="<?php echo e(request('from')); ?>">
      </div>
      <div>
        <label class="label">To</label>
        <input class="input" type="date" name="to" value="<?php echo e(request('to')); ?>">
      </div>
      <div>
        <label class="label">Status</label>
        <select name="status" class="input">
          <option value="">All</option>
          <option value="success" <?php if(request('status')==='success'): echo 'selected'; endif; ?>>Success</option>
          <option value="pending" <?php if(request('status')==='pending'): echo 'selected'; endif; ?>>Pending</option>
          <option value="failed" <?php if(request('status')==='failed'): echo 'selected'; endif; ?>>Failed</option>
        </select>
      </div>
      <div style="align-self:flex-end">
        <button class="btn-ghost" type="submit">Filter</button>
      </div>
    </form>

    <table>
      <thead>
      <tr>
        <th>Ref</th>
        <th>Status</th>
        <th>Router</th>
        <th>Plan</th>
        <th>Phone</th>
        <th>Amount</th>
        <th>Date</th>
      </tr>
      </thead>
      <tbody>
      <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td><?php echo e($o->reference); ?></td>
          <td>
            <span class="status <?php echo e($o->status); ?>">
              <?php echo e(ucfirst($o->status)); ?>

            </span>
          </td>
          <td><?php echo e($o->router->name ?? '—'); ?></td>
          <td><?php echo e($o->plan->name ?? '—'); ?></td>
          <td><?php echo e($o->phone); ?></td>
          <td><?php echo e(number_format($o->amount)); ?> <?php echo e($o->currency); ?></td>
          <td class="muted"><?php echo e($o->created_at->format('Y-m-d H:i')); ?></td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr><td colspan="7" class="muted">No orders found.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>

    <div style="margin-top:10px">
      <?php echo e($orders->withQueryString()->links()); ?>

    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.freelancer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/freelancer/sales.blade.php ENDPATH**/ ?>