
<?php $__env->startSection('title','Hotspot Logs — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom:12px">
  <h1 style="margin:0 0 4px">Hotspot Logs</h1>
  <div class="muted">System log entries from MikroTik <code>/log</code> for topic <strong>hotspot</strong>.</div>
</div>

<div class="card full" style="margin-bottom:14px">
  <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;align-items:center">
    <div>
      <label class="label">Router</label>
      <select name="router_id" class="input" onchange="this.form.submit()">
        <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($r->id); ?>" <?php if($router && $router->id === $r->id): echo 'selected'; endif; ?>><?php echo e($r->name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>

    <div>
      <label class="label">Show last</label>
      <select name="limit" class="input" onchange="this.form.submit()">
        <?php $__currentLoopData = [50,100,200,500]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($l); ?>" <?php if($limit==$l): echo 'selected'; endif; ?>>Last <?php echo e($l); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>

    <div style="flex:1;min-width:180px">
      <label class="label">Search text</label>
      <input name="q" class="input" value="<?php echo e($search); ?>" placeholder="filter by message…">
    </div>

    <div style="align-self:flex-end">
      <button class="btn">Filter</button>
    </div>

    <div style="margin-left:auto;text-align:right">
      <div class="muted" style="font-size:12px">
        Router:
        <strong><?php echo e($router?->name ?? '—'); ?></strong>
        <?php if($router): ?>
          <span style="opacity:.8">(<?php echo e($router->host); ?>)</span>
        <?php endif; ?>
      </div>
      <div class="muted" style="font-size:12px;margin-top:2px">
        <?php echo e(count($logs)); ?> entries loaded
      </div>
    </div>
  </form>
</div>

<?php if($error): ?>
  <div class="card full" style="border-color:rgba(239,68,68,.4);background:rgba(239,68,68,.08)">
    <strong style="color:var(--bb-red)">Router error:</strong>
    <div class="muted" style="margin-top:4px"><?php echo e($error); ?></div>
  </div>
<?php elseif(!$router): ?>
  <div class="card full">
    <div class="muted">No routers found. Please add a router first.</div>
  </div>
<?php else: ?>
  <div class="card full">
    <table>
      <thead>
        <tr>
          <th style="width:140px">Time</th>
          <th style="width:120px">Topics</th>
          <th>Message</th>
        </tr>
      </thead>
      <tbody>
      <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
          <td class="muted"><?php echo e($row['time'] ?? ''); ?></td>
          <td><span class="status" style="border-radius:999px;font-size:11px">
            <?php echo e($row['topics'] ?? ''); ?>

          </span></td>
          <td><?php echo e($row['message'] ?? ''); ?></td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <tr><td colspan="3" class="muted">No log entries found for this filter.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/hotspot/logs/index.blade.php ENDPATH**/ ?>