
<?php $__env->startSection('title','New Plan — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <h1 style="margin:0 0 12px">New Plan</h1>

  <div class="card full">
    <form method="POST" action="<?php echo e(route('plans.store')); ?>">
      <?php echo csrf_field(); ?>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id">
            <option value="">All routers / generic</option>
            <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $router): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($router->id); ?>" <?php if(old('router_id') == $router->id): echo 'selected'; endif; ?>>
                <?php echo e($router->name); ?>

              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
          <div class="muted" style="font-size:12px;margin-top:4px">
            Optional. Leave empty to use this plan on any router.
          </div>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="<?php echo e(old('name')); ?>" required
                 placeholder="6 Hours, 24 Hours, 3 Days ...">
        </div>

        <div>
          <label class="label">Profile (MikroTik)</label>
          <input class="input" name="profile" value="<?php echo e(old('profile')); ?>"
                 placeholder="e.g. 6H, 24H, DAILY">
          <div class="muted" style="font-size:12px;margin-top:4px">
            Must match hotspot <code>/ip hotspot user profile</code> name.
          </div>
        </div>

        <div>
          <label class="label">Validity (hours)</label>
          <input class="input" type="number" name="validity_hours"
                 value="<?php echo e(old('validity_hours', 24)); ?>" required>
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" value="<?php echo e(old('rate_limit')); ?>"
                 placeholder="e.g. 5M/5M">
        </div>

        <div>
          <label class="label">Download limit (MB)</label>
          <input class="input" type="number" name="download_limit_mb"
                 value="<?php echo e(old('download_limit_mb')); ?>">
        </div>

        <div>
          <label class="label">Upload limit (MB)</label>
          <input class="input" type="number" name="upload_limit_mb"
                 value="<?php echo e(old('upload_limit_mb')); ?>">
        </div>

        <div>
          <label class="label">Price (TZS)</label>
          <input class="input" type="number" name="price"
                 value="<?php echo e(old('price', 1000)); ?>" required>
        </div>

        <div>
          <label class="label">Currency</label>
          <input class="input" name="currency" value="<?php echo e(old('currency','TZS')); ?>">
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="is_active">
            <option value="1" <?php if(old('is_active',1)==1): echo 'selected'; endif; ?>>Active</option>
            <option value="0" <?php if(old('is_active')==0): echo 'selected'; endif; ?>>Disabled</option>
          </select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="<?php echo e(route('plans.index')); ?>" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save Plan</button>
      </div>
    </form>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/plans/create.blade.php ENDPATH**/ ?>