@extends('layouts.app')
@section('title','OpenVPN Profile')

@section('content')
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px">
    <h1 style="margin:0">OpenVPN Profile — {{ $vpn->common_name }}</h1>
    <div style="display:flex;gap:8px">
      @if($ovpnUrl)
        <a class="btn" href="{{ $ovpnUrl }}">Download .ovpn</a>
      @endif
      <form method="POST" action="{{ route('vpn.revoke',$vpn) }}">@csrf
        <button class="btn-ghost" onclick="return confirm('Revoke this client?')">Revoke</button>
      </form>
    </div>
  </div>

  <div class="cards">
    <div class="card">
      <div class="label">Router</div>
      <div class="value">{{ $router->name }}</div>
      <div class="muted">{{ $router->host }}</div>
    </div>
    <div class="card">
      <div class="label">VPN IP</div>
      <div class="value">{{ $vpn->static_ip }}</div>
    </div>
    <div class="card">
      <div class="label">Status</div>
      <span class="status {{ $vpn->status === 'active' ? 'paid' : ($vpn->status==='error'?'failed':'pending') }}">{{ $vpn->status }}</span>
    </div>

    <div class="card full">
      <strong>MikroTik — copy & paste</strong>
      <pre style="margin-top:8px;white-space:pre-wrap;border:1px solid var(--bb-border);border-radius:12px;padding:12px;background:var(--bb-elev);color:var(--bb-text)">{{ $mikrotik }}</pre>
      <div class="muted" style="margin-top:6px">Upload the CA/CRT/KEY blocks from the .ovpn into <em>Files</em> (or leave bundled if using a desktop client).</div>
    </div>
  </div>
@endsection
