@extends('layouts.app')
@section('title','Create OpenVPN — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 10px">Create OpenVPN for: {{ $router->name }}</h1>

  <div class="card full">
    <form method="POST" action="{{ route('vpn.store',$router) }}">
      @csrf
      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">OpenVPN Server</label>
          <select name="openvpn_server_id" class="input" required>
            @foreach($servers as $s)
              <option value="{{ $s->id }}">{{ $s->name }} ({{ $s->host }})</option>
            @endforeach
          </select>
        </div>
        <div>
          <label class="label">Common Name (CN)</label>
          <input class="input" name="common_name" value="{{ $suggestCN }}" required>
        </div>
        <div>
          <label class="label">Static VPN IP</label>
          <input class="input" name="static_ip" value="{{ $suggestIP }}" required>
        </div>
      </div>
      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('routers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Generate</button>
      </div>
    </form>
  </div>
@endsection
