@extends('layouts.app')
@section('title','New Voucher — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">New Voucher (Agent / Cash)</h1>

  <div class="card full">
    <form method="POST" action="{{ route('vouchers.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id" required>
            @foreach($routers as $router)
              <option value="{{ $router->id }}" @selected(old('router_id')==$router->id)>
                {{ $router->name }}
              </option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Plan</label>
          <select class="input" name="plan_id" required>
            @foreach($plans as $plan)
              <option value="{{ $plan->id }}" @selected(old('plan_id')==$plan->id)>
                {{ $plan->name }} — {{ number_format($plan->price) }} {{ $plan->currency }}
              </option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Buyer phone (optional)</label>
          <input class="input" name="buyer_phone"
                 value="{{ old('buyer_phone') }}" placeholder="2557xxxxxxxx">
        </div>

        <div style="display:flex;align-items:center;gap:8px;margin-top:22px">
          <input type="checkbox" id="send_sms" name="send_sms" value="1"
                 @checked(old('send_sms',1))>
          <label for="send_sms" class="muted" style="font-size:13px">
            Send voucher via SMS (Beem)
          </label>
        </div>

      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('vouchers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Generate Voucher</button>
      </div>
    </form>
  </div>
@endsection
