@extends('layouts.app')
@section('title','Edit User — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 10px">Edit User</h1>

  <div class="card full">
    <form method="POST" action="{{ route('users.update',$user) }}">
      @csrf
      @method('PUT')

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ old('name',$user->name) }}" required>
          @error('name')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Email</label>
          <input class="input" type="email" name="email" value="{{ old('email',$user->email) }}" required>
          @error('email')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Password (leave blank to keep)</label>
          <input class="input" type="password" name="password">
          @error('password')<div class="muted" style="color:var(--bb-red)">{{ $message }}</div>@enderror
        </div>

        <div>
          <label class="label">Roles</label>
          <div style="display:flex;flex-wrap:wrap;gap:6px">
            @forelse($roles as $role)
              <label style="font-size:13px">
                <input type="checkbox" name="roles[]" value="{{ $role->name }}"
                  {{ in_array($role->name,$userRoles) ? 'checked' : '' }}>
                {{ $role->name }}
              </label>
            @empty
              <div class="muted" style="font-size:12px">No roles yet.</div>
            @endforelse
          </div>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:space-between;align-items:center;gap:8px">
        <form method="POST" action="{{ route('users.destroy',$user) }}"
              onsubmit="return confirm('Delete this user?')">
          @csrf @method('DELETE')
          <button class="btn-ghost" style="color:var(--bb-red)">Delete</button>
        </form>

        <div>
          <a href="{{ route('users.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
          <button class="btn">Save Changes</button>
        </div>
      </div>
    </form>
  </div>
@endsection
