@extends('layouts.app')
@section('title','Plans — BlueBando v3')

@section('content')
  {{-- Header + router filter + actions --}}
  <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:14px;gap:12px;flex-wrap:wrap">
    <div>
      <h1 style="margin:0 0 4px">Plans</h1>
      <div class="muted">Manage hotspot plans / profiles per router. Changes are synced to MikroTik.</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center;flex-wrap:wrap">
      <form method="get" action="{{ route('plans.index') }}">
        <select class="input" name="router_id" onchange="this.form.submit()">
          <option value="">All routers</option>
          @foreach($routers as $r)
            <option value="{{ $r->id }}" @selected(($routerId ?? null) == $r->id)>{{ $r->name }}</option>
          @endforeach
        </select>
      </form>

      <a href="{{ route('plans.create') }}" class="btn" style="text-decoration:none;white-space:nowrap">
        + New Plan
      </a>
    </div>
  </div>

  {{-- Flash message --}}
  @if (session('status'))
    <div class="card full" style="margin-bottom:12px;border-left:3px solid var(--bb-green)">
      <div style="display:flex;align-items:center;gap:8px">
        <span style="font-size:18px">✅</span>
        <div>{{ session('status') }}</div>
      </div>
    </div>
  @endif

  {{-- Plans table (from DB) --}}
  <div class="card full">
    @if($plans->count())
      <table>
        <thead>
          <tr>
            <th style="width:180px">Name / Profile</th>
            <th>Router</th>
            <th>Price</th>
            <th>Validity</th>
            <th>Rate Limit</th>
            <th>DL / UL Limit (MB)</th>
            <th>Status</th>
            <th style="width:120px">Updated</th>
            <th style="width:140px;text-align:right">Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($plans as $plan)
            <tr>
              <td>
                <div style="font-weight:600">{{ $plan->name }}</div>
                <div class="muted" style="font-size:12px">
                  Profile: {{ $plan->profile ?: $plan->name }}
                </div>
              </td>

              <td>
                @if($plan->router)
                  <div>{{ $plan->router->name }}</div>
                  <div class="muted" style="font-size:12px">{{ $plan->router->host }}</div>
                @else
                  <span class="muted" style="font-size:12px">Any router</span>
                @endif
              </td>

              <td>
                {{ number_format($plan->price) }}
                <span class="muted">{{ $plan->currency ?: config('bluebando.currency','TZS') }}</span>
              </td>

              <td>{{ $plan->validity_hours }}h</td>

              <td>{{ $plan->rate_limit ?: '—' }}</td>

              <td>
                @php
                  $dl = $plan->download_limit_mb;
                  $ul = $plan->upload_limit_mb;
                @endphp
                @if($dl || $ul)
                  {{ $dl ?: 0 }}/{{ $ul ?: 0 }}
                @else
                  <span class="muted">Unlimited</span>
                @endif
              </td>

              <td>
                @if($plan->is_active)
                  <span class="status paid">Active</span>
                @else
                  <span class="status pending">Disabled</span>
                @endif
              </td>

              <td class="muted">
                {{ optional($plan->updated_at)->diffForHumans() ?? '—' }}
              </td>

              <td style="text-align:right">
                <div style="display:flex;justify-content:flex-end;gap:6px">
                  <a href="{{ route('plans.edit',$plan) }}"
                     class="btn-ghost"
                     style="padding:6px 10px;font-size:12px;text-decoration:none">
                    Edit
                  </a>

                  <form method="POST" action="{{ route('plans.destroy',$plan) }}"
                        onsubmit="return confirm('Delete this plan and its router profile?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit"
                            class="btn-ghost"
                            style="padding:6px 10px;font-size:12px;border-color:rgba(239,68,68,.4);color:var(--bb-red)">
                      Delete
                    </button>
                  </form>
                </div>
              </td>
            </tr>
          @endforeach
        </tbody>
      </table>

      {{-- Pagination --}}
      <div style="margin-top:12px">
        {{ $plans->withQueryString()->links() }}
      </div>
    @else
      <div class="muted">
        No plans found yet. Click <strong>“+ New Plan”</strong> to create your first hotspot plan
        and it will be synced to MikroTik automatically.
      </div>
    @endif
  </div>

  {{-- Live profiles directly from MikroTik for selected router --}}
  @if(!empty($liveRouter))
    <div style="margin-top:18px">
      <h2 style="margin:0 0 6px;font-size:18px">
        Live profiles on router:
        <span style="font-weight:600">{{ $liveRouter->name }}</span>
        <span class="muted" style="font-size:12px">({{ $liveRouter->host }})</span>
      </h2>
      <div class="muted" style="font-size:12px;margin-bottom:8px">
        Data fetched in real-time from <code>/ip hotspot user profile</code>.
      </div>

      <div class="card full">
        @if(!empty($liveProfiles))
          <table>
            <thead>
              <tr>
                <th>Name</th>
                <th>Rate limit</th>
                <th>Shared users</th>
                <th>Idle timeout</th>
                <th>Keepalive</th>
                <th>Parent queue</th>
                <th>Comment</th>
              </tr>
            </thead>
            <tbody>
              @foreach($liveProfiles as $p)
                <tr>
                  <td>{{ $p['name'] }}</td>
                  <td>{{ $p['rate_limit'] ?? '—' }}</td>
                  <td>{{ $p['shared_users'] ?? '—' }}</td>
                  <td>{{ $p['idle_timeout'] ?? '—' }}</td>
                  <td>{{ $p['keepalive_timeout'] ?? '—' }}</td>
                  <td>{{ $p['parent_queue'] ?? '—' }}</td>
                  <td class="muted">{{ $p['comment'] ?? '—' }}</td>
                </tr>
              @endforeach
            </tbody>
          </table>
        @else
          <div class="muted">
            No hotspot user profiles found on this router
            (or failed to read API). Check MikroTik API connectivity & permissions.
          </div>
        @endif
      </div>
    </div>
  @endif
@endsection