@extends('layouts.app')
@section('title','New Plan — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">New Plan</h1>

  <div class="card full">
    <form method="POST" action="{{ route('plans.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id">
            <option value="">All routers / generic</option>
            @foreach($routers as $router)
              <option value="{{ $router->id }}" @selected(old('router_id') == $router->id)>
                {{ $router->name }}
              </option>
            @endforeach
          </select>
          <div class="muted" style="font-size:12px;margin-top:4px">
            Optional. Leave empty to use this plan on any router.
          </div>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ old('name') }}" required
                 placeholder="6 Hours, 24 Hours, 3 Days ...">
        </div>

        <div>
          <label class="label">Profile (MikroTik)</label>
          <input class="input" name="profile" value="{{ old('profile') }}"
                 placeholder="e.g. 6H, 24H, DAILY">
          <div class="muted" style="font-size:12px;margin-top:4px">
            Must match hotspot <code>/ip hotspot user profile</code> name.
          </div>
        </div>

        <div>
          <label class="label">Validity (hours)</label>
          <input class="input" type="number" name="validity_hours"
                 value="{{ old('validity_hours', 24) }}" required>
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" value="{{ old('rate_limit') }}"
                 placeholder="e.g. 5M/5M">
        </div>

        <div>
          <label class="label">Download limit (MB)</label>
          <input class="input" type="number" name="download_limit_mb"
                 value="{{ old('download_limit_mb') }}">
        </div>

        <div>
          <label class="label">Upload limit (MB)</label>
          <input class="input" type="number" name="upload_limit_mb"
                 value="{{ old('upload_limit_mb') }}">
        </div>

        <div>
          <label class="label">Price (TZS)</label>
          <input class="input" type="number" name="price"
                 value="{{ old('price', 1000) }}" required>
        </div>

        <div>
          <label class="label">Currency</label>
          <input class="input" name="currency" value="{{ old('currency','TZS') }}">
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="is_active">
            <option value="1" @selected(old('is_active',1)==1)>Active</option>
            <option value="0" @selected(old('is_active')==0)>Disabled</option>
          </select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('plans.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save Plan</button>
      </div>
    </form>
  </div>
@endsection
