@extends('layouts.app')
@section('title','Order '.$order->reference.' — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px">
    <h1 style="margin:0 0 4px">Order {{ $order->reference }}</h1>
    <div class="muted">Detailed information for this payment.</div>
  </div>

  <div class="card full" style="display:grid;grid-template-columns:repeat(2,1fr);gap:16px">
    <div>
      <h3 style="margin:0 0 6px;font-size:15px">Basic</h3>
      <div class="muted" style="font-size:13px">
        <div><strong>Status:</strong> {{ ucfirst($order->status) }}</div>
        <div><strong>Gateway:</strong> {{ strtoupper($order->gateway) }}</div>
        <div><strong>Channel:</strong> {{ $order->channel }}</div>
        <div><strong>Amount:</strong> {{ number_format($order->amount) }} {{ $order->currency }}</div>
        <div><strong>Phone:</strong> {{ $order->phone }}</div>
        <div><strong>Created:</strong> {{ $order->created_at }}</div>
        <div><strong>Paid at:</strong> {{ $order->paid_at ?? '—' }}</div>
      </div>
    </div>

    <div>
      <h3 style="margin:0 0 6px;font-size:15px">Context</h3>
      <div class="muted" style="font-size:13px">
        <div><strong>Router:</strong> {{ $order->router->name ?? '—' }}</div>
        <div><strong>Plan:</strong> {{ $order->plan->name ?? '—' }}</div>
        <div><strong>User (staff):</strong> {{ $order->user->name ?? '—' }}</div>
      </div>
    </div>

    <div style="grid-column:1/-1">
      <h3 style="margin:12px 0 6px;font-size:15px">Raw Meta</h3>
      <pre style="font-size:12px;background:var(--bb-elev);border-radius:12px;padding:10px;overflow:auto">
{{ json_encode($order->meta, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES) }}
      </pre>
    </div>
  </div>
@endsection
