@extends('layouts.app')
@section('title','Matokeo ya Malipo — BlueBando')

@section('content')
<div style="max-width:560px;margin:0 auto">
  <h1 style="margin-bottom:8px;font-size:22px">Malipo ya WiFi</h1>
  <div class="muted" style="margin-bottom:12px">
    Router: <strong>{{ $router->name }}</strong> ({{ $router->site }})<br>
    Kifurushi: <strong>{{ $plan->name }}</strong> –
    {{ number_format($plan->price) }} {{ $plan->currency ?? 'TZS' }}
  </div>

  <div class="card full" style="padding:18px 18px 20px">
    <div style="margin-bottom:6px;font-size:13px">
      Rejea ya malipo: <strong>{{ $order->reference }}</strong>
    </div>

    @if($mode === 'success' || $order->status === 'success')
      <div style="margin:10px 0 14px;padding:10px 12px;border-radius:12px;
                  background:color-mix(in srgb,var(--bb-green) 12%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-green) 45%,transparent);">
        Malipo yako <strong>yamekamilika</strong>. Asante! 🎉
      </div>

      @if($order->voucher_code)
        <div style="margin-bottom:10px">
          <div class="label" style="margin-bottom:4px">Voucher yako ya WiFi</div>
          <div style="font-size:22px;font-weight:800;letter-spacing:2px;
                      padding:10px 12px;border-radius:14px;text-align:center;
                      background:var(--bb-elev);border:1px dashed var(--bb-border)">
            {{ $order->voucher_code }}
          </div>
          <div class="muted" style="font-size:12px;margin-top:6px">
            Voucher hii pia imetumwa kwenye SMS namba {{ $order->phone }}.
          </div>
        </div>
      @else
        <div class="muted" style="font-size:13px">
          Malipo yako yamekamilika, tunatengeneza voucher yako. Tafadhali jaribu
          kurudisha ukurasa baada ya sekunde chache.
        </div>
      @endif

    @elseif($mode === 'failed' || $order->status === 'failed')
      <div style="margin:10px 0 14px;padding:10px 12px;border-radius:12px;
                  background:color-mix(in srgb,var(--bb-red) 12%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-red) 45%,transparent);">
        Samahani, malipo <strong>yameshindikana</strong>. Jaribu tena au
        hakikisha una salio la kutosha.
      </div>
    @else
      {{-- pending / after initial submit --}}
      <div style="margin:10px 0 14px;padding:10px 12px;border-radius:12px;
                  background:var(--bb-elev);border:1px solid var(--bb-border);">
        <div style="font-weight:600;margin-bottom:4px">
          Malipo yanaendelea…
        </div>
        <div class="muted" style="font-size:13px">
          Tumepeleka ombi la malipo kwa <strong>{{ $order->network }}</strong>.
          Ukipokea ujumbe wa USSD au push kwenye simu yako
          <strong>{{ $order->phone }}</strong>, kumbuka kuthibitisha.
        </div>
      </div>

      <div class="muted" style="font-size:12px">
        Ukishalipa, unaweza kubonyeza kitufe hiki kuangalia kama voucher
        tayari imetengenezwa:
      </div>

      <a href="{{ route('payment.result',$order->reference) }}"
         class="btn" style="margin-top:10px;display:inline-flex;align-items:center;gap:6px;text-decoration:none">
        Angalia tena status
      </a>
    @endif
  </div>

  <div class="muted" style="font-size:11px;margin-top:8px">
    BlueBando • Malipo yanasimamiwa na AzamPay.
  </div>
</div>
@endsection
