@extends('layouts.app')

@section('title', 'Lipa WiFi — BlueBando')

@section('content')
<div style="max-width:480px;margin:0 auto">
  <h1 style="margin-bottom:10px;font-size:22px">Lipa kifurushi cha WiFi</h1>
  <div class="muted" style="margin-bottom:16px">
    Router: <strong>{{ $router->name }}</strong> ({{ $router->site }})
  </div>

  <div class="card full" style="padding:18px 18px 20px">
    <form method="POST" action="{{ route('payment.create') }}">
      @csrf
      <input type="hidden" name="router_id" value="{{ $router->id }}">

      {{-- Mtandao --}}
      <div style="margin-bottom:12px">
        <label class="label" style="margin-bottom:4px">Chagua Mtandao</label>
        <select name="network" class="input" required>
          <option value="">-- Chagua Mtandao --</option>
          <option value="Airtel" {{ old('network')=='Airtel'?'selected':'' }}>Airtel Money</option>
          <option value="Tigo" {{ old('network')=='Tigo'?'selected':'' }}>TigoPesa</option>
          <option value="Halopesa" {{ old('network')=='Halopesa'?'selected':'' }}>Halopesa</option>
          <option value="Azampesa" {{ old('network')=='Azampesa'?'selected':'' }}>Azampesa</option>
        </select>
        @error('network')<div class="muted" style="color:var(--bb-red);font-size:12px">{{ $message }}</div>@enderror
      </div>

      {{-- Namba ya simu --}}
      <div style="margin-bottom:12px">
        <label class="label" style="margin-bottom:4px">Weka Namba ya Simu</label>
        <input type="tel" name="phone" class="input"
               placeholder="weka namba hapa (mfano 0784xxxxxx)"
               value="{{ old('phone') }}" required>
        <div class="muted" style="font-size:12px;margin-top:4px">
          Tutaiweka moja kwa moja kwenye mfumo wa <strong>255…</strong>
        </div>
        @error('phone')<div class="muted" style="color:var(--bb-red);font-size:12px">{{ $message }}</div>@enderror
      </div>

      {{-- Kifurushi (plans from DB) --}}
      <div style="margin-bottom:12px">
        <label class="label" style="margin-bottom:4px">Chagua Kifurushi</label>
        <select name="plan_id" class="input" required>
          <option value="">-- Chagua kifurushi --</option>
          @foreach($plans as $plan)
            <option value="{{ $plan->id }}" {{ old('plan_id')==$plan->id?'selected':'' }}>
              {{ $plan->name }} – {{ number_format($plan->price) }} {{ $plan->currency ?? 'TZS' }}
            </option>
          @endforeach
        </select>
        @error('plan_id')<div class="muted" style="color:var(--bb-red);font-size:12px">{{ $message }}</div>@enderror
      </div>

      {{-- Gateway (for now AzamPay only) --}}
      <div style="margin-bottom:18px">
        <div class="label" style="margin-bottom:6px">Bonyeza “Lipa Sasa” kufanya malipo</div>
        <label style="display:flex;align-items:center;gap:8px;cursor:pointer">
          <input type="radio" name="gateway" value="azampay" checked>
          <div>
            <div><strong>AzamPay</strong></div>
            <div class="muted" style="font-size:12px">
              Airtel, Tigo, Halopesa, Azampesa
            </div>
          </div>
        </label>
      </div>

      <button type="submit" class="btn" style="width:100%;justify-content:center">
        Lipa Sasa
      </button>

      @if ($errors->any())
        <div style="margin-top:12px;font-size:12px;color:var(--bb-red)">
          Tafadhali rekebisha taarifa ulizoingiza.
        </div>
      @endif
    </form>
  </div>

  <div class="muted" style="font-size:12px;margin-top:10px">
    Baada ya malipo kukamilika, utapokea <strong>Voucher ya WiFi</strong> kwenye skrini
    na kwa <strong>SMS</strong>.
  </div>
</div>
@endsection
