<!DOCTYPE html>
<html lang="{{ str_replace('_','-',app()->getLocale()) }}">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>@yield('title','Freelancer — BlueBando v3')</title>

  <style>
    :root{
      --bb-primary-1:#3b82f6; --bb-primary-2:#0ea5e9;
      --bb-bg:#0d1117; --bb-surface:#0f172a; --bb-panel:#111827; --bb-elev:#0b1220;
      --bb-border:rgba(148,163,184,.12);
      --bb-text:#e5e7eb; --bb-dim:#9ca3af;
      --bb-green:#10b981; --bb-red:#ef4444; --bb-yellow:#f59e0b;
      --radius:16px; --shadow:0 18px 60px rgba(0,0,0,.45);
      --sidebar-w:230px; --topbar-h:60px;
    }

    body{
      margin:0; color:var(--bb-text);
      font:14px/1.45 system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Helvetica,Arial,sans-serif;
      background:
        radial-gradient(1200px 700px at 80% -10%, #0b3a6b33, transparent 60%),
        radial-gradient(1200px 700px at -10% 110%, #064e3b22, transparent 60%),
        linear-gradient(180deg,#0b1020,var(--bb-bg));
    }
    *{box-sizing:border-box}

    .layout{display:grid;grid-template-columns:var(--sidebar-w) 1fr;min-height:100vh}
    .sidebar{
      background:linear-gradient(180deg,#020617,#020617);
      border-right:1px solid var(--bb-border);
      display:flex;flex-direction:column;
    }
    .content{min-width:0;display:flex;flex-direction:column}

    .topbar{
      height:var(--topbar-h);display:flex;align-items:center;gap:12px;
      padding:0 18px;border-bottom:1px solid var(--bb-border);
      background:rgba(15,23,42,.9);backdrop-filter:blur(8px);position:sticky;top:0;z-index:10;
    }
    .brand-mini{display:flex;align-items:center;gap:8px}
    .brand-mini img{width:22px;height:22px}
    .brand-mini strong{font-size:15px}

    .top-spacer{flex:1}
    .avatar{
      width:28px;height:28px;border-radius:999px;
      display:grid;place-items:center;font-weight:700;
      background:#1f2937;border:1px solid var(--bb-border);
    }
    .muted{color:var(--bb-dim)}

    .page{padding:18px}
    .cards{display:grid;grid-template-columns:repeat(12,1fr);gap:14px}
    .card{
      grid-column:span 3;
      background:linear-gradient(180deg,rgba(255,255,255,.02),transparent),var(--bb-panel);
      border-radius:var(--radius);
      border:1px solid var(--bb-border);
      box-shadow:var(--shadow);
      padding:14px;
    }
    .card.wide{grid-column:span 6}
    .card.full{grid-column:1/-1}

    .kpi{display:flex;align-items:center;gap:10px}
    .kpi .icon{
      width:34px;height:34px;border-radius:10px;
      display:grid;place-items:center;
      background:#0b1220;border:1px solid rgba(148,163,184,.18);
    }
    .kpi .label{font-size:12px;color:var(--bb-dim)}
    .kpi .value{font-size:21px;font-weight:800}

    .nav{padding:12px}
    .nav .section{
      color:var(--bb-dim);font-size:11px;letter-spacing:.08em;
      text-transform:uppercase;margin:14px 10px 6px;
    }
    .nav a{
      display:flex;align-items:center;gap:8px;
      padding:9px 11px;border-radius:12px;
      color:var(--bb-text);text-decoration:none;
      border:1px solid transparent;font-size:13px;
    }
    .nav a:hover{background:#020617}
    .nav a.active{background:#0f172a;border-color:var(--bb-border)}
    .nav .label{white-space:nowrap}

    .footer{
      padding:12px 18px;font-size:12px;margin-top:18px;
      border-top:1px solid var(--bb-border);color:var(--bb-dim);
    }

    table{width:100%;border-collapse:collapse;font-size:13px}
    th,td{padding:8px 6px;border-bottom:1px solid rgba(148,163,184,.12);text-align:left}
    th{font-size:11px;text-transform:uppercase;letter-spacing:.06em;color:var(--bb-dim)}
    .status{
      display:inline-block;padding:3px 7px;border-radius:999px;
      font-size:11px;border:1px solid;
    }
    .status.success{background:#10b9811a;border-color:#10b98166;color:#bbf7d0}
    .status.pending{background:#f59e0b1a;border-color:#f59e0b66;color:#fed7aa}
    .status.failed{background:#ef44441a;border-color:#ef444466;color:#fecaca}

    .btn{
      background:linear-gradient(135deg,var(--bb-primary-1),var(--bb-primary-2));
      border-radius:999px;border:0;color:#fff;
      padding:8px 14px;font-size:13px;cursor:pointer;
    }
    .btn-ghost{
      background:#020617;border-radius:999px;border:1px solid var(--bb-border);
      color:var(--bb-text);padding:8px 12px;font-size:13px;cursor:pointer;
    }

    @media(max-width:900px){
      .layout{grid-template-columns:1fr}
      .sidebar{display:none}
    }
  </style>
</head>
<body>
  <div class="layout">
    <aside class="sidebar">
      <div style="padding:14px 14px 8px;display:flex;align-items:center;gap:8px;border-bottom:1px solid var(--bb-border)">
        <img src="{{ asset('images/bluebando-logo.svg') }}" alt="BB" width="24" height="24"
             onerror="this.style.display='none'">
        <div>
          <div style="font-weight:800;font-size:14px">BlueBando</div>
          <div class="muted" style="font-size:11px">Freelancer Portal</div>
        </div>
      </div>

      <nav class="nav">
        <div class="section">Overview</div>
        <a href="{{ route('freelancer.dashboard') }}"
           class="{{ request()->routeIs('freelancer.dashboard') ? 'active' : '' }}">
          <x-ico name="home" :size="18" /> <span class="label">Dashboard</span>
        </a>

        <a href="{{ route('freelancer.sales') }}"
           class="{{ request()->routeIs('freelancer.sales') ? 'active' : '' }}">
          <x-ico name="receipt-percent" :size="18" /> <span class="label">My Sales</span>
        </a>

        <a href="{{ route('freelancer.routers') }}"
           class="{{ request()->routeIs('freelancer.routers') ? 'active' : '' }}">
          <x-ico name="server" :size="18" /> <span class="label">Routers</span>
        </a>

        <div class="section">Account</div>
        <a href="{{ route('freelancer.profile') }}"
           class="{{ request()->routeIs('freelancer.profile') ? 'active' : '' }}">
          <x-ico name="user" :size="18" /> <span class="label">Profile</span>
        </a>

        <form method="POST" action="{{ route('logout') }}" style="margin-top:10px">
          @csrf
          <button class="btn-ghost" style="width:100%;text-align:left;color:var(--bb-red)">
            <x-ico name="logout" :size="18" /> <span class="label">Logout</span>
          </button>
        </form>
      </nav>
    </aside>

    <div class="content">
      <header class="topbar">
        <div class="brand-mini">
          <img src="{{ asset('images/bluebando-logo.svg') }}" alt="">
          <strong>BlueBando</strong>
        </div>

        <div class="top-spacer"></div>

        <div class="muted" style="font-size:12px;margin-right:8px">
          Freelancer Portal
        </div>

        @php $u = auth()->user(); @endphp
        <div style="display:flex;align-items:center;gap:8px">
          <div class="avatar">{{ strtoupper(substr($u->name ?? 'U',0,1)) }}</div>
          <div style="text-align:right">
            <div style="font-size:13px">{{ $u->name ?? 'User' }}</div>
            <div class="muted" style="font-size:11px">{{ $currentFreelancer->code ?? 'Freelancer' }}</div>
          </div>
        </div>
      </header>

      <main class="page">
        @yield('content')
        <div class="footer">
          © {{ date('Y') }} BlueBando WiFi — Freelancer Portal
        </div>
      </main>
    </div>
  </div>
</body>
</html>
