@extends('layouts.app')
@section('title','Freelancers — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">Freelancers</h1>
      <div class="muted">Manage agents who sell vouchers and earn commission.</div>
    </div>
    <a href="{{ route('freelancers.create') }}" class="btn" style="text-decoration:none">Add Freelancer</a>
  </div>

  <div class="cards" style="margin-bottom:16px">
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="user-group" :size="20" /></div>
        <div>
          <div class="label">Total Freelancers</div>
          <div class="value">{{ $stats['count'] ?? 0 }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="user" :size="20" /></div>
        <div>
          <div class="label">Active</div>
          <div class="value">{{ $stats['active'] ?? 0 }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="user-minus" :size="20" /></div>
        <div>
          <div class="label">Suspended</div>
          <div class="value">{{ $stats['suspended'] ?? 0 }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="currency-dollar" :size="20" /></div>
        <div>
          <div class="label">This Month Sales</div>
          <div class="value">{{ number_format($stats['month_sales'] ?? 0) }} TZS</div>
        </div>
      </div>
    </div>
  </div>

  <div class="card full">
    <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:10px">
      <div class="top-search" style="flex:1;max-width:260px">
        <input name="q" value="{{ request('q') }}" placeholder="Search by name, phone or code…"
               class="input">
      </div>

      <div>
        <label class="label">Status</label>
        <select name="status" class="input" onchange="this.form.submit()">
          <option value="">All</option>
          <option value="active" @selected($status==='active')>Active</option>
          <option value="suspended" @selected($status==='suspended')>Suspended</option>
        </select>
      </div>

      <div style="align-self:flex-end">
        <button class="btn-ghost" type="submit">Filter</button>
      </div>
    </form>

    <table>
      <thead>
      <tr>
        <th>#</th>
        <th>Name</th>
        <th>Phone</th>
        <th>Code</th>
        <th>Commission</th>
        <th>Status</th>
        <th>Routers</th>
        <th></th>
      </tr>
      </thead>
      <tbody>
      @forelse($freelancers as $f)
        <tr>
          <td>{{ $f->id }}</td>
          <td><a href="{{ route('freelancers.show',$f) }}">{{ $f->name }}</a></td>
          <td>{{ $f->phone }}</td>
          <td>{{ $f->code ?? '—' }}</td>
          <td>{{ $f->commission_rate }}%</td>
          <td>
            <span class="status {{ $f->status === 'active' ? 'paid' : 'failed' }}">
              {{ ucfirst($f->status) }}
            </span>
          </td>
          <td class="muted">
            {{ $f->routers()->count() }} router(s)
          </td>
          <td style="text-align:right">
            <a href="{{ route('freelancers.edit',$f) }}" class="btn-ghost" style="font-size:12px">Edit</a>
          </td>
        </tr>
      @empty
        <tr><td colspan="8" class="muted">No freelancers yet.</td></tr>
      @endforelse
      </tbody>
    </table>

    <div style="margin-top:10px">
      {{ $freelancers->withQueryString()->links() }}
    </div>
  </div>
@endsection
