@extends('layouts.freelancer')
@section('title','My Sales — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">My Sales</h1>
      <div class="muted">All orders where you are the freelancer.</div>
    </div>
  </div>

  <div class="card full">
    <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:10px">
      <div>
        <label class="label">From</label>
        <input class="input" type="date" name="from" value="{{ request('from') }}">
      </div>
      <div>
        <label class="label">To</label>
        <input class="input" type="date" name="to" value="{{ request('to') }}">
      </div>
      <div>
        <label class="label">Status</label>
        <select name="status" class="input">
          <option value="">All</option>
          <option value="success" @selected(request('status')==='success')>Success</option>
          <option value="pending" @selected(request('status')==='pending')>Pending</option>
          <option value="failed" @selected(request('status')==='failed')>Failed</option>
        </select>
      </div>
      <div style="align-self:flex-end">
        <button class="btn-ghost" type="submit">Filter</button>
      </div>
    </form>

    <table>
      <thead>
      <tr>
        <th>Ref</th>
        <th>Status</th>
        <th>Router</th>
        <th>Plan</th>
        <th>Phone</th>
        <th>Amount</th>
        <th>Date</th>
      </tr>
      </thead>
      <tbody>
      @forelse($orders as $o)
        <tr>
          <td>{{ $o->reference }}</td>
          <td>
            <span class="status {{ $o->status }}">
              {{ ucfirst($o->status) }}
            </span>
          </td>
          <td>{{ $o->router->name ?? '—' }}</td>
          <td>{{ $o->plan->name ?? '—' }}</td>
          <td>{{ $o->phone }}</td>
          <td>{{ number_format($o->amount) }} {{ $o->currency }}</td>
          <td class="muted">{{ $o->created_at->format('Y-m-d H:i') }}</td>
        </tr>
      @empty
        <tr><td colspan="7" class="muted">No orders found.</td></tr>
      @endforelse
      </tbody>
    </table>

    <div style="margin-top:10px">
      {{ $orders->withQueryString()->links() }}
    </div>
  </div>
@endsection
