@extends('layouts.freelancer')
@section('title','My Profile — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px">
    <h1 style="margin:0 0 4px">My Profile</h1>
    <div class="muted">Basic account and freelancer information.</div>
  </div>

  <div class="cards">
    <div class="card wide">
      <h3 style="margin:0 0 8px;font-size:15px">Account</h3>
      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:8px;font-size:13px">
        <div>
          <div class="muted">Name</div>
          <div>{{ $user->name }}</div>
        </div>
        <div>
          <div class="muted">Email</div>
          <div>{{ $user->email }}</div>
        </div>
        <div>
          <div class="muted">Freelancer Code</div>
          <div>{{ $freelancer->code ?? '—' }}</div>
        </div>
        <div>
          <div class="muted">Phone</div>
          <div>{{ $freelancer->phone }}</div>
        </div>
        <div>
          <div class="muted">Commission Rate</div>
          <div>{{ $freelancer->commission_rate }}%</div>
        </div>
        <div>
          <div class="muted">Status</div>
          <div>
            <span class="status {{ $freelancer->status === 'active' ? 'success' : 'failed' }}">
              {{ ucfirst($freelancer->status) }}
            </span>
          </div>
        </div>
      </div>
    </div>

    <div class="card wide">
      <h3 style="margin:0 0 8px;font-size:15px">Notes</h3>
      <div class="muted" style="font-size:13px;white-space:pre-line">
        {{ $freelancer->notes ?: 'No notes yet.' }}
      </div>
    </div>
  </div>
@endsection
