@extends('layouts.freelancer')
@section('title','Freelancer Dashboard — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px">
    <h1 style="margin:0 0 4px">Dashboard</h1>
    <div class="muted">Hi {{ $freelancer->name }}, here is a quick overview of your performance.</div>
  </div>

  <section class="cards" style="margin-bottom:16px">
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="banknotes" :size="20" /></div>
        <div>
          <div class="label">Today Sales</div>
          <div class="value">{{ number_format($todaySales) }} TZS</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="calendar" :size="20" /></div>
        <div>
          <div class="label">This Month</div>
          <div class="value">{{ number_format($monthSales) }} TZS</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="currency-dollar" :size="20" /></div>
        <div>
          <div class="label">Total Sales</div>
          <div class="value">{{ number_format($totalSales) }} TZS</div>
        </div>
      </div>
    </div>

    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="receipt-percent" :size="20" /></div>
        <div>
          <div class="label">Estimated Commission ({{ $commissionRate }}%)</div>
          <div class="value">{{ number_format($totalCommission) }} TZS</div>
        </div>
      </div>
    </div>
  </section>

  <div class="card full">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:8px">
      <strong>Recent Successful Orders</strong>
      <a href="{{ route('freelancer.sales') }}" class="btn-ghost" style="text-decoration:none;font-size:12px">
        View all
      </a>
    </div>

    <table>
      <thead>
      <tr>
        <th>Ref</th>
        <th>Router</th>
        <th>Plan</th>
        <th>Phone</th>
        <th>Amount</th>
        <th>Date</th>
      </tr>
      </thead>
      <tbody>
      @forelse($recentOrders as $o)
        <tr>
          <td>{{ $o->reference }}</td>
          <td>{{ $o->router->name ?? '—' }}</td>
          <td>{{ $o->plan->name ?? '—' }}</td>
          <td>{{ $o->phone }}</td>
          <td>{{ number_format($o->amount) }} {{ $o->currency }}</td>
          <td class="muted">{{ $o->created_at->format('Y-m-d H:i') }}</td>
        </tr>
      @empty
        <tr><td colspan="6" class="muted">No sales yet.</td></tr>
      @endforelse
      </tbody>
    </table>
  </div>
@endsection
