<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('vouchers', function (Blueprint $table) {
        $table->id();
        $table->foreignId('router_id')->constrained()->cascadeOnDelete();
        $table->foreignId('plan_id')->constrained()->cascadeOnDelete();

        $table->string('code')->unique();      // hotspot username
        $table->string('password');            // hotspot password
        $table->enum('status', ['pending','active','used','expired','cancelled'])
              ->default('pending');

        $table->string('buyer_phone', 20)->nullable();
        $table->timestamp('activated_at')->nullable();
        $table->timestamp('used_at')->nullable();
        $table->timestamp('expires_at')->nullable();

        $table->foreignId('payment_id')->nullable()->constrained()->nullOnDelete();
        $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();

        $table->unsignedInteger('price')->default(0);
        $table->string('currency', 10)->default('TZS');

        $table->json('meta')->nullable();      // anything extra
        $table->timestamps();
    });
}

public function down(): void
{
    Schema::dropIfExists('vouchers');
}

};
