<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('plans', function (Blueprint $table) {
        $table->id();
        $table->foreignId('router_id')->nullable()->constrained()->nullOnDelete();
        $table->string('name');
        $table->string('profile')->nullable();     // MikroTik profile name
        $table->unsignedInteger('price');         // TZS
        $table->string('currency', 10)->default('TZS');
        $table->unsignedInteger('validity_hours'); // e.g. 6, 24, 72
        $table->unsignedInteger('download_limit_mb')->nullable();
        $table->unsignedInteger('upload_limit_mb')->nullable();
        $table->string('rate_limit')->nullable(); // e.g. "5M/5M"
        $table->boolean('is_active')->default(true);
        $table->timestamps();
    });
}

public function down(): void
{
    Schema::dropIfExists('plans');
}

};
