<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('routers', function (Blueprint $table) {
            $table->string('last_status')
                  ->default('unknown')        // online/offline/error
                  ->after('vpn_ip');

            $table->integer('last_latency_ms')
                  ->nullable()
                  ->after('last_status');

            $table->string('last_identity')
                  ->nullable()
                  ->after('last_latency_ms');

            $table->string('last_model')
                  ->nullable()
                  ->after('last_identity');

            $table->string('last_cpu')
                  ->nullable()
                  ->after('last_model');      // e.g. "23%"

            $table->string('last_uptime')
                  ->nullable()
                  ->after('last_cpu');        // e.g. "3d9h6m4s"

            $table->timestamp('last_checked_at')
                  ->nullable()
                  ->after('last_uptime');
        });
    }

    public function down(): void
    {
        Schema::table('routers', function (Blueprint $table) {
            $table->dropColumn([
                'last_status',
                'last_latency_ms',
                'last_identity',
                'last_model',
                'last_cpu',
                'last_uptime',
                'last_checked_at',
            ]);
        });
    }
};