<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('vpn_clients', function (Blueprint $t) {
            $t->id();
            $t->foreignId('router_id')->constrained()->cascadeOnDelete();
            $t->foreignId('openvpn_server_id')->constrained()->cascadeOnDelete();

            $t->string('common_name')->unique();       // e.g. BB-RT-12
            $t->string('static_ip')->nullable();       // e.g. 10.8.0.10
            $t->enum('status',['new','provisioning','active','error','revoked'])->default('new');

            // fetched artifacts (stored locally)
            $t->string('crt_path')->nullable();
            $t->string('key_path')->nullable();
            $t->string('ovpn_path')->nullable();
            $t->text('last_error')->nullable();

            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('vpn_clients'); }
};
