<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    'azampay' => [
    'base_url'       => env('AZAMPAY_BASE_URL', 'https://sandbox.azampay.co.tz'),
    'app_name'       => env('AZAMPAY_APP_NAME'),
    'client_id'      => env('AZAMPAY_CLIENT_ID'),
    'client_secret'  => env('AZAMPAY_CLIENT_SECRET'),
    'api_key'        => env('AZAMPAY_API_KEY'),
    'account_number' => env('AZAMPAY_ACCOUNT_NUMBER'),
    'callback_url'   => env('AZAMPAY_CALLBACK_URL', env('APP_URL').'/payments/azampay/callback'),
],
'beem' => [
    'api_key'    => env('BEEM_API_KEY'),
    'secret_key' => env('BEEM_SECRET_KEY'),
    'sender_id'  => env('BEEM_SENDER_ID', 'BlueBando'),
],


];
