<?php
namespace App\Services\Sms;

use InvalidArgumentException;

class SmsFactory {
    public function for(string $provider): SmsGateway {
        return match($provider) {
            'beem'   => app(BeemGateway::class),
            'twilio' => app(TwilioGateway::class),
            'nextsms'=> app(NextSmsGateway::class),
            default  => throw new InvalidArgumentException('Unknown SMS provider: '.$provider)
        };
    }
}
interface SmsGateway {
    public function send(string $to, string $message, array $meta=[]): SmsResult;
}
class SmsResult {
    public function __construct(public bool $ok, public ?array $meta=null) {}
}
