<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Voucher extends Model
{
    protected $fillable = [
        'router_id','plan_id','code','password','status',
        'buyer_phone','activated_at','used_at','expires_at',
        'payment_id','created_by','price','currency','meta',
    ];

    protected $casts = [
        'activated_at' => 'datetime',
        'used_at'      => 'datetime',
        'expires_at'   => 'datetime',
        'meta'         => 'array',
    ];

    public function router()
    {
        return $this->belongsTo(Router::class);
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function payment()
    {
        return $this->belongsTo(Payment::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    protected function isActive(): Attribute
    {
        return Attribute::get(fn () => $this->status === 'active');
    }
}
