<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    protected $fillable = [
        'router_id','name','profile','price','currency',
        'validity_hours','download_limit_mb','upload_limit_mb',
        'rate_limit','is_active',
    ];

    public function router()
    {
        return $this->belongsTo(Router::class);
    }

    public function vouchers()
    {
        return $this->hasMany(Voucher::class);
    }
}
