<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $fillable = [
        'gateway','reference','gateway_reference',
        'customer_msisdn','amount','currency','status',
        'router_id','plan_id','voucher_id','paid_at',
        'request_payload','response_payload','callback_payload',
    ];

    protected $casts = [
        'paid_at'          => 'datetime',
        'request_payload'  => 'array',
        'response_payload' => 'array',
        'callback_payload' => 'array',
    ];

    public function plan()    { return $this->belongsTo(Plan::class); }
    public function router()  { return $this->belongsTo(Router::class); }
    public function voucher() { return $this->hasOne(Voucher::class); }
}
