<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Freelancer extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'user_id',
        'name',
        'phone',
        'email',
        'code',
        'commission_rate',
        'status',
        'notes',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function routers()
    {
        return $this->belongsToMany(Router::class, 'freelancer_router');
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }
}
