<?php

namespace App\Http\Controllers\FreelancerPortal;

use App\Http\Controllers\Controller;
use App\Models\Freelancer;
use App\Models\Order;
use Illuminate\Http\Request;

class FreelancerDashboardController extends Controller
{
    protected function freelancer(Request $request): Freelancer
    {
        return $request->attributes->get('freelancer');
    }

    public function index(Request $request)
    {
        $freelancer = $this->freelancer($request);

        $base = Order::where('freelancer_id', $freelancer->id)
            ->where('status', 'success');

        $todaySales = (clone $base)->whereDate('created_at', now()->toDateString())->sum('amount');
        $monthSales = (clone $base)->whereMonth('created_at', now()->month)
            ->whereYear('created_at', now()->year)
            ->sum('amount');
        $totalSales = (clone $base)->sum('amount');

        $recentOrders = (clone $base)->latest()->limit(10)->get();

        $commissionRate  = $freelancer->commission_rate;
        $totalCommission = round($totalSales * $commissionRate / 100, 2);

        return view('freelancer.dashboard', compact(
            'freelancer',
            'todaySales',
            'monthSales',
            'totalSales',
            'totalCommission',
            'recentOrders',
            'commissionRate'
        ));
    }

    public function sales(Request $request)
    {
        $freelancer = $this->freelancer($request);

        $q = Order::where('freelancer_id', $freelancer->id);

        if ($status = $request->input('status')) {
            $q->where('status', $status);
        }

        if ($from = $request->input('from')) {
            $q->whereDate('created_at', '>=', $from);
        }

        if ($to = $request->input('to')) {
            $q->whereDate('created_at', '<=', $to);
        }

        $orders = $q->latest()->paginate(25);

        return view('freelancer.sales', compact('freelancer', 'orders'));
    }

    public function routers(Request $request)
    {
        $freelancer = $this->freelancer($request);
        $routers = $freelancer->routers()->orderBy('name')->get();

        return view('freelancer.routers', compact('freelancer', 'routers'));
    }

    public function profile(Request $request)
    {
        $freelancer = $this->freelancer($request);
        $user = $request->user();

        return view('freelancer.profile', compact('freelancer', 'user'));
    }
}
