
<?php $__env->startSection('title','Add Freelancer — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <h1 style="margin:0 0 10px">Add Freelancer</h1>

  <div class="card full">
    <form method="POST" action="<?php echo e(route('freelancers.store')); ?>">
      <?php echo csrf_field(); ?>

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="<?php echo e(old('name')); ?>" required>
        </div>

        <div>
          <label class="label">Phone</label>
          <input class="input" name="phone" value="<?php echo e(old('phone')); ?>" required>
        </div>

        <div>
          <label class="label">Email (optional)</label>
          <input class="input" name="email" value="<?php echo e(old('email')); ?>">
        </div>

        <div>
          <label class="label">Code / Agent ID</label>
          <input class="input" name="code" value="<?php echo e(old('code')); ?>" placeholder="e.g. BB-AGENT-01">
        </div>

        <div>
          <label class="label">Commission Rate (%)</label>
          <input class="input" type="number" step="0.01" name="commission_rate"
                 value="<?php echo e(old('commission_rate', 10)); ?>" required>
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="status">
            <option value="active" <?php if(old('status','active')==='active'): echo 'selected'; endif; ?>>Active</option>
            <option value="suspended" <?php if(old('status')==='suspended'): echo 'selected'; endif; ?>>Suspended</option>
          </select>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Linked User Account (login)</label>
          <select class="input" name="user_id">
            <option value="">-- Select existing user for login --</option>
            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($u->id); ?>" <?php if(old('user_id')==$u->id): echo 'selected'; endif; ?>>
                <?php echo e($u->name); ?> (<?php echo e($u->email); ?>)
              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
          <div class="muted" style="font-size:12px;margin-top:4px">
            This user will use <strong>/login</strong> to access the Freelancer Portal.
            Create the user first under <em>Users & Roles</em>.
          </div>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Assigned Routers</label>
          <div style="display:flex;flex-wrap:wrap;gap:8px">
            <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <label style="font-size:13px">
                <input type="checkbox" name="router_ids[]"
                       value="<?php echo e($r->id); ?>" <?php echo e(in_array($r->id, old('router_ids',[])) ? 'checked' : ''); ?>>
                <?php echo e($r->name); ?> (<?php echo e($r->site); ?>)
              </label>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Notes</label>
          <textarea class="input" name="notes" rows="3"><?php echo e(old('notes')); ?></textarea>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:flex-end;gap:8px">
        <a href="<?php echo e(route('freelancers.index')); ?>" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save Freelancer</button>
      </div>
    </form>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/freelancers/create.blade.php ENDPATH**/ ?>