
<?php $__env->startSection('title','Hotspot Vouchers — BlueBando v3'); ?>

<?php $__env->startSection('content'); ?>
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center;gap:12px">
    <div>
      <h1 style="margin:0 0 6px;font-size:22px">Hotspot Vouchers</h1>
      <div class="muted">Latest hotspot users read directly from MikroTik (limited).</div>
    </div>

    <div style="display:flex;gap:8px;align-items:center">
      <form method="GET" action="<?php echo e(route('hotspot.vouchers.index')); ?>" style="display:flex;gap:6px;align-items:center">
        <select name="router_id" class="input" style="min-width:160px">
          <?php $__currentLoopData = $routers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($r->id); ?>" <?php if(optional($currentRouter)->id === $r->id): echo 'selected'; endif; ?>><?php echo e($r->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <select name="limit" class="input" style="width:90px">
          <?php $__currentLoopData = [50,100,200,500]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($opt); ?>" <?php if($limit == $opt): echo 'selected'; endif; ?>>last <?php echo e($opt); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <button class="btn-ghost" type="submit">Load</button>
      </form>

      <a href="<?php echo e(route('hotspot.vouchers.bulk', ['router_id'=>optional($currentRouter)->id])); ?>" class="btn-ghost" style="text-decoration:none">Generate Bulk</a>
      <a href="<?php echo e(route('hotspot.vouchers.create', ['router_id'=>optional($currentRouter)->id])); ?>" class="btn" style="text-decoration:none">Add Voucher</a>
    </div>
  </div>

  <div class="card full">
    <?php if(session('success')): ?>
      <div style="margin-bottom:10px;font-size:13px;padding:8px 10px;border-radius:10px;
                  background:color-mix(in srgb,var(--bb-green) 10%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-green) 40%,transparent)">
        <?php echo e(session('success')); ?>

      </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
      <div style="margin-bottom:10px;font-size:13px;padding:8px 10px;border-radius:10px;
                  background:color-mix(in srgb,var(--bb-red) 10%,transparent);
                  border:1px solid color-mix(in srgb,var(--bb-red) 40%,transparent)">
        <?php echo e(session('error')); ?>

      </div>
    <?php endif; ?>

    <?php if($offline): ?>
      <div class="muted" style="margin-bottom:8px">Router seems offline or API not reachable.</div>
    <?php endif; ?>

    <?php $codes = session('generated_codes', []); ?>
    <?php if(!empty($codes)): ?>
      <div style="margin-bottom:12px">
        <div style="font-size:13px;margin-bottom:4px">Recently generated codes:</div>
        <div style="display:flex;flex-wrap:wrap;gap:6px">
          <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <code style="padding:4px 6px;border-radius:6px;background:var(--bb-elev);border:1px solid var(--bb-border)"><?php echo e($c); ?></code>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    <?php endif; ?>

    <?php if(empty($routerUsers)): ?>
      <div class="muted">No vouchers found (or none within the selected limit).</div>
    <?php else: ?>
      <table>
        <thead>
        <tr>
          <th>Code</th>
          <th>Profile</th>
          <th>Comment</th>
          <th>Status</th>
          <th>Uptime</th>
          <th>RX</th>
          <th>TX</th>
          <th style="width:150px">Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $routerUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $disabled = ($u['disabled'] ?? 'false') === 'true';
            $status   = $disabled ? 'Disabled' : 'Enabled';
          ?>
          <tr>
            <td><?php echo e($u['name'] ?? ''); ?></td>
            <td><?php echo e($u['profile'] ?? ''); ?></td>
            <td><?php echo e($u['comment'] ?? ''); ?></td>
            <td>
              <span class="status <?php echo e($disabled ? 'failed' : 'paid'); ?>">
                <?php echo e($status); ?>

              </span>
            </td>
            <td><?php echo e($u['uptime'] ?? '-'); ?></td>
            <td><?php echo e($u['bytes-in']  ?? '-'); ?></td>
            <td><?php echo e($u['bytes-out'] ?? '-'); ?></td>
            <td>
              <a href="<?php echo e(route('hotspot.vouchers.print',$u['name'] ?? '')); ?>" class="muted" target="_blank">Print</a>
               |
              <form method="POST"
                    action="<?php echo e(route('hotspot.vouchers.destroy',$u['name'] ?? '')); ?>?router_id=<?php echo e(optional($currentRouter)->id); ?>"
                    style="display:inline"
                    onsubmit="return confirm('Delete voucher <?php echo e($u['name'] ?? ''); ?> from router?')">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button type="submit"
                        style="background:none;border:0;color:var(--bb-red);cursor:pointer;font-size:13px">
                  Delete
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    <?php endif; ?>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\bluebando-v3\resources\views/hotspot/vouchers/index.blade.php ENDPATH**/ ?>