@extends('layouts.app')
@section('title','Users & Roles — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">Users & Roles</h1>
      <div class="muted">Manage staff accounts, permissions and link them to freelancers.</div>
    </div>
    <a href="{{ route('users.create') }}" class="btn" style="text-decoration:none">Add User</a>
  </div>

  <div class="cards" style="margin-bottom:16px">
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="users" :size="20" /></div>
        <div>
          <div class="label">Total Users</div>
          <div class="value">{{ \App\Models\User::count() }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="shield-check" :size="20" /></div>
        <div>
          <div class="label">Roles</div>
          <div class="value">{{ $roles->count() }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="user-group" :size="20" /></div>
        <div>
          <div class="label">Freelancers (linked)</div>
          <div class="value">{{ \App\Models\Freelancer::whereNotNull('user_id')->count() }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="cog" :size="20" /></div>
        <div>
          <div class="label">System Admins</div>
          <div class="value">
            {{ \App\Models\User::role('admin')->count() ?? 0 }}
          </div>
        </div>
      </div>
    </div>
  </div>

  {{-- Filter + roles panel --}}
  <div class="cards" style="margin-bottom:16px">
    <div class="card wide">
      <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;align-items:flex-end">
        <div class="top-search" style="flex:1;max-width:260px">
          <input name="q" class="input" placeholder="Search by name or email…" value="{{ request('q') }}">
        </div>
        <div>
          <button class="btn-ghost" type="submit">Filter</button>
        </div>
      </form>
    </div>

    <div class="card wide">
      <h3 style="margin:0 0 8px;font-size:15px">Roles</h3>
      <div class="muted" style="font-size:12px;margin-bottom:6px">
        Basic overview of roles available for assignment. You can seed typical roles like <strong>admin</strong>, <strong>manager</strong>, <strong>freelancer</strong>.
      </div>
      <div style="display:flex;flex-wrap:wrap;gap:6px;margin-bottom:8px">
        @forelse($roles as $role)
          <span class="bb-badge">
            <span class="bb-emo">🛡</span> {{ $role->name }}
          </span>
        @empty
          <span class="muted">No roles yet. Create them via artisan or tinker (e.g. Role::create(['name' => 'admin']);).</span>
        @endforelse
      </div>
      <div class="muted" style="font-size:11px">
        For now roles are created via CLI. Later we can add full CRUD for roles & permissions if you want.
      </div>
    </div>
  </div>

  {{-- Users table --}}
  <div class="card full">
    <table>
      <thead>
      <tr>
        <th>#</th>
        <th>Name</th>
        <th>Email</th>
        <th>Roles</th>
        <th>Freelancer</th>
        <th></th>
      </tr>
      </thead>
      <tbody>
      @forelse($users as $u)
        @php
          $roles = $u->getRoleNames();
          $freelancer = \App\Models\Freelancer::where('user_id',$u->id)->first();
        @endphp
        <tr>
          <td>{{ $u->id }}</td>
          <td>{{ $u->name }}</td>
          <td>{{ $u->email }}</td>
          <td>
            <div class="bb-role-badges">
              @forelse($roles as $r)
                <span class="bb-badge">
                  <span class="bb-emo">⭐</span> {{ $r }}
                </span>
              @empty
                <span class="muted" style="font-size:12px">No role</span>
              @endforelse
            </div>
          </td>
          <td>
            @if($freelancer)
              <span class="bb-badge">
                <span class="bb-emo">💼</span> {{ $freelancer->code ?? 'Freelancer' }}
              </span>
            @else
              <span class="muted" style="font-size:12px">—</span>
            @endif
          </td>
          <td style="text-align:right">
            <a href="{{ route('users.edit',$u) }}" class="btn-ghost" style="font-size:12px">Edit</a>
          </td>
        </tr>
      @empty
        <tr><td colspan="6" class="muted">No users found.</td></tr>
      @endforelse
      </tbody>
    </table>

    <div style="margin-top:10px">
      {{ $users->withQueryString()->links() }}
    </div>
  </div>
@endsection
