@extends('layouts.app')
@section('title','Add Router — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">Add Router</h1>

  <div class="card full">
    <form method="POST" action="{{ route('routers.store') }}">
      @csrf
     <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
  <div>
    <label class="label">Connection via</label>
    <select class="input" name="connection_via" onchange="bbConnChange(this.value)">
      <option value="public" selected>Public (IP or DDNS)</option>
      <option value="vpn">VPN (future)</option>
    </select>
    <div class="muted" style="font-size:12px;margin-top:4px">
      For now choose <b>Public</b>. We’ll add VPN later.
    </div>
  </div>

  <div>
    <label class="label">API Port</label>
    <input class="input" type="number" name="api_port" value="8728">
    <div class="muted" style="font-size:12px;margin-top:4px">Use 8729 if API-SSL (TLS) is enabled on the router.</div>
  </div>

  <div>
    <label class="label">Public IP</label>
    <input class="input" name="wan_host" placeholder="e.g. 41.59.x.x">
  </div>
  <div>
    <label class="label">DDNS Hostname</label>
    <input class="input" name="ddns_host" placeholder="xxxx.sn.mynetname.net">
  </div>

  <div>
    <label class="label">Username</label>
    <input class="input" name="username" required>
  </div>
  <div>
    <label class="label">Password</label>
    <input class="input" type="password" name="password" required>
  </div>

  <div>
    <label class="label">TLS (api-ssl)</label>
    <select class="input" name="use_tls">
      <option value="0" selected>No</option>
      <option value="1">Yes</option>
    </select>
  </div>
  <div>
    <label class="label">Site (optional)</label>
    <input class="input" name="site">
  </div>
</div>

<script>
function bbConnChange(v){
  // simple UX: if VPN chosen, gray out public fields (future)
}
</script>


      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('routers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save</button>
      </div>
    </form>
  </div>
@endsection
