@extends('layouts.app')
@section('title','Edit Plan — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">Edit Plan</h1>

  <div class="card full">
    <form method="POST" action="{{ route('plans.update',$plan) }}">
      @csrf
      @method('PUT')

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">

        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id">
            <option value="">All routers / generic</option>
            @foreach($routers as $router)
              <option value="{{ $router->id }}" @selected($plan->router_id == $router->id)>
                {{ $router->name }}
              </option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ $plan->name }}" required>
        </div>

        <div>
          <label class="label">Profile (MikroTik)</label>
          <input class="input" name="profile" value="{{ $plan->profile }}">
        </div>

        <div>
          <label class="label">Validity (hours)</label>
          <input class="input" type="number" name="validity_hours"
                 value="{{ $plan->validity_hours }}" required>
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" value="{{ $plan->rate_limit }}">
        </div>

        <div>
          <label class="label">Download limit (MB)</label>
          <input class="input" type="number" name="download_limit_mb"
                 value="{{ $plan->download_limit_mb }}">
        </div>

        <div>
          <label class="label">Upload limit (MB)</label>
          <input class="input" type="number" name="upload_limit_mb"
                 value="{{ $plan->upload_limit_mb }}">
        </div>

        <div>
          <label class="label">Price (TZS)</label>
          <input class="input" type="number" name="price"
                 value="{{ $plan->price }}" required>
        </div>

        <div>
          <label class="label">Currency</label>
          <input class="input" name="currency" value="{{ $plan->currency }}">
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="is_active">
            <option value="1" @selected($plan->is_active)>Active</option>
            <option value="0" @selected(!$plan->is_active)>Disabled</option>
          </select>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;gap:8px;justify-content:flex-end">
        <a href="{{ route('plans.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Update Plan</button>
      </div>
    </form>
  </div>
@endsection
