@extends('layouts.app')
@section('title','Orders — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">Orders</h1>
      <div class="muted">All payment orders from web, freelancers and ATM (future).</div>
    </div>
    <a href="{{ route('checkout.form') }}" class="btn" style="text-decoration:none">New Checkout</a>
  </div>

  <div class="card full" style="margin-bottom:10px">
    <form method="get" style="display:flex;flex-wrap:wrap;gap:10px">
      <div>
        <label class="label">Status</label>
        <select name="status" class="input" onchange="this.form.submit()">
          <option value="">All</option>
          @foreach(['pending','success','failed'] as $s)
            <option value="{{ $s }}" @selected($status===$s)>{{ ucfirst($s) }}</option>
          @endforeach
        </select>
      </div>
      <div>
        <label class="label">Gateway</label>
        <select name="gateway" class="input" onchange="this.form.submit()">
          <option value="">All</option>
          @foreach(['azam_pay'] as $g)
            <option value="{{ $g }}" @selected($gateway===$g)>{{ strtoupper($g) }}</option>
          @endforeach
        </select>
      </div>
    </form>
  </div>

  <div class="card full">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Ref</th>
          <th>Router</th>
          <th>Plan</th>
          <th>Phone</th>
          <th>Amount</th>
          <th>Gateway</th>
          <th>Status</th>
          <th>Created</th>
        </tr>
      </thead>
      <tbody>
      @forelse($orders as $o)
        <tr>
          <td>{{ $o->id }}</td>
          <td><a href="{{ route('orders.show',$o) }}">{{ $o->reference }}</a></td>
          <td>{{ $o->router->name ?? '—' }}</td>
          <td>{{ $o->plan->name ?? '—' }}</td>
          <td>{{ $o->phone }}</td>
          <td>{{ number_format($o->amount) }} {{ $o->currency }}</td>
          <td>{{ strtoupper($o->gateway) }}</td>
          <td>
            <span class="status {{ $o->status }}">
              {{ ucfirst($o->status) }}
            </span>
          </td>
          <td class="muted">{{ $o->created_at?->format('Y-m-d H:i') }}</td>
        </tr>
      @empty
        <tr><td colspan="9" class="muted">No orders yet.</td></tr>
      @endforelse
      </tbody>
    </table>

    <div style="margin-top:10px">
      {{ $orders->withQueryString()->links() }}
    </div>
  </div>
@endsection
