@extends('layouts.app')
@section('title','Malipo yanafanyika…')

@section('content')
<div style="max-width:460px;margin:0 auto;text-align:center">
  <h1 style="margin-bottom:8px">Malipo yanafanyika…</h1>
  <p class="muted" style="margin-bottom:16px">
    Tumetuma ombi la malipo kwa namba <strong>{{ $order->phone }}</strong>.
    Tafadhali thibitisha kwenye simu yako.
  </p>

  <div class="card full" style="padding:18px">
    <p style="margin-bottom:4px">
      Kifurushi: <strong>{{ optional($order->plan)->name }}</strong>
    </p>
    <p style="margin-bottom:4px">
      Kiasi: <strong>{{ number_format($order->amount) }} {{ $order->currency }}</strong>
    </p>
    <p class="muted" style="font-size:12px">
      Order: {{ $order->reference }} • Status: {{ ucfirst($order->status) }}
    </p>
  </div>

  <p class="muted" style="margin-top:16px;font-size:13px">
    Ukimaliza kuthibitisha, ukurasa utasasishwa kiotomatiki kuangalia kama malipo
    yamekamilika.
  </p>
</div>

<script>
// auto poll status every 5s
setInterval(function(){
  fetch('{{ route('pay.pending', $order) }}', {headers:{'X-Requested-With':'XMLHttpRequest'}})
    .then(r => r.json().catch(() => null))
    .then(j => {
      if(!j) return;
      if(j.status === 'success'){
        window.location.href = '{{ route('pay.success', $order) }}';
      }else if(j.status === 'failed'){
        window.location.href = '{{ route('pay.failed', $order) }}';
      }
    }).catch(()=>{});
}, 5000);
</script>
@endsection
