@extends('layouts.app')
@section('title','Bulk Vouchers — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:center">
    <h1 style="margin:0 0 6px;font-size:22px">Generate Bulk Vouchers</h1>
    <a href="{{ route('hotspot.vouchers.index',['router_id'=>optional($currentRouter)->id]) }}" class="btn-ghost" style="text-decoration:none">Back</a>
  </div>

  <div class="card full">
    <form method="POST" action="{{ route('hotspot.vouchers.bulk.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Router</label>
          <select name="router_id" class="input" required>
            @foreach($routers as $r)
              <option value="{{ $r->id }}" @selected(optional($currentRouter)->id === $r->id)>{{ $r->name }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Profile</label>
          <select name="profile" class="input" required>
            <option value="">Select profile…</option>
            @foreach($profiles as $p)
              <option value="{{ $p['name'] ?? '' }}">{{ $p['name'] ?? '' }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Quantity (max 200)</label>
          <input type="number" min="1" max="200" name="quantity" class="input" value="{{ old('quantity',50) }}">
        </div>

        <div>
          <label class="label">Prefix (optional)</label>
          <input type="text" name="prefix" class="input" value="{{ old('prefix') }}">
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Comment (optional)</label>
          <input type="text" name="comment" class="input" value="{{ old('comment') }}">
        </div>
      </div>

      <div style="margin-top:16px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('hotspot.vouchers.index',['router_id'=>optional($currentRouter)->id]) }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn" type="submit">Generate</button>
      </div>
    </form>
  </div>
@endsection
