@extends('layouts.app')
@section('title','New Hotspot Profile — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 12px">New Hotspot Profile</h1>

  <div class="card full">
    <form method="POST" action="{{ route('hotspot.profiles.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Router</label>
          <select class="input" name="router_id" required>
            @foreach($routers as $r)
              <option value="{{ $r->id }}" @selected($routerId == $r->id)>{{ $r->name }}</option>
            @endforeach
          </select>
        </div>

        <div>
          <label class="label">Name</label>
          <input class="input" name="name" required placeholder="6H, 24H, DAILY" value="{{ old('name') }}">
        </div>

        <div>
          <label class="label">Rate limit</label>
          <input class="input" name="rate_limit" placeholder="5M/5M" value="{{ old('rate_limit') }}">
        </div>

        <div>
          <label class="label">Shared users</label>
          <input class="input" name="shared_users" placeholder="1,2,3..." value="{{ old('shared_users') }}">
        </div>

        <div>
          <label class="label">Idle timeout</label>
          <input class="input" name="idle_timeout" placeholder="00:05:00" value="{{ old('idle_timeout') }}">
        </div>

        <div>
          <label class="label">Keepalive timeout</label>
          <input class="input" name="keepalive_timeout" placeholder="00:02:00" value="{{ old('keepalive_timeout') }}">
        </div>

        <div>
          <label class="label">Parent queue</label>
          <input class="input" name="parent_queue" value="{{ old('parent_queue') }}">
        </div>

        <div>
          <label class="label">Comment</label>
          <input class="input" name="comment" value="{{ old('comment') }}">
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('hotspot.profiles.index') }}" class="btn-ghost" style="text-decoration:none">
          Cancel
        </a>
        <button class="btn">Save Profile</button>
      </div>
    </form>
  </div>
@endsection
