@extends('layouts.app')
@section('title','Hotspot User Log — BlueBando v3')

@section('content')
<div style="margin-bottom:12px">
  <h1 style="margin:0 0 4px">Hotspot User Log</h1>
  <div class="muted">
    Login / logout / auth events filtered from MikroTik <code>/log</code>.
  </div>
</div>

<div class="card full" style="margin-bottom:14px">
  <form method="get" style="display:flex;flex-wrap:wrap;gap:10px;align-items:center">
    <div>
      <label class="label">Router</label>
      <select name="router_id" class="input" onchange="this.form.submit()">
        @foreach($routers as $r)
          <option value="{{ $r->id }}" @selected($router && $router->id === $r->id)>{{ $r->name }}</option>
        @endforeach
      </select>
    </div>

    <div>
      <label class="label">Show last</label>
      <select name="limit" class="input" onchange="this.form.submit()">
        @foreach([50,100,200,500] as $l)
          <option value="{{ $l }}" @selected($limit==$l)>Last {{ $l }}</option>
        @endforeach
      </select>
    </div>

    <div style="flex:1;min-width:160px">
      <label class="label">Filter by user (optional)</label>
      <input name="user" class="input" value="{{ $userFilter }}" placeholder="e.g. 88888886">
    </div>

    <div style="align-self:flex-end">
      <button class="btn">Filter</button>
    </div>

    <div style="margin-left:auto;text-align:right">
      <div class="muted" style="font-size:12px">
        Router:
        <strong>{{ $router?->name ?? '—' }}</strong>
        @if($router)
          <span style="opacity:.8">({{ $router->host }})</span>
        @endif
      </div>
      <div class="muted" style="font-size:12px;margin-top:2px">
        {{ count($logs) }} entries loaded
      </div>
    </div>
  </form>
</div>

@if($error)
  <div class="card full" style="border-color:rgba(239,68,68,.4);background:rgba(239,68,68,.08)">
    <strong style="color:var(--bb-red)">Router error:</strong>
    <div class="muted" style="margin-top:4px">{{ $error }}</div>
  </div>
@elseif(!$router)
  <div class="card full">
    <div class="muted">No routers found. Please add a router first.</div>
  </div>
@else
  <div class="card full">
    <table>
      <thead>
        <tr>
          <th style="width:140px">Time</th>
          <th style="width:120px">Topics</th>
          <th>Message</th>
        </tr>
      </thead>
      <tbody>
      @forelse($logs as $row)
        <tr>
          <td class="muted">{{ $row['time'] ?? '' }}</td>
          <td><span class="status" style="border-radius:999px;font-size:11px">
            {{ $row['topics'] ?? '' }}
          </span></td>
          <td>{{ $row['message'] ?? '' }}</td>
        </tr>
      @empty
        <tr><td colspan="3" class="muted">No user log entries for this filter.</td></tr>
      @endforelse
      </tbody>
    </table>
  </div>
@endif
@endsection
