@extends('layouts.app')
@section('title','Hotspot History — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 10px">Hotspot Session History</h1>
  <div class="card full">
    <div style="margin-bottom:10px;font-size:13px" class="muted">
      Last 200 snapshots (each snapshot is taken when you open the Active page).
    </div>

    @if($logs->count())
      <div style="overflow-x:auto">
        <table>
          <thead>
          <tr>
            <th>Seen At</th>
            <th>Router</th>
            <th>User</th>
            <th>Address</th>
            <th>MAC</th>
            <th>Bytes In</th>
            <th>Bytes Out</th>
            <th>Login By</th>
          </tr>
          </thead>
          <tbody>
          @foreach($logs as $l)
            <tr>
              <td>{{ $l->seen_at }}</td>
              <td>{{ $l->router_id }}</td>
              <td>{{ $l->user }}</td>
              <td>{{ $l->address }}</td>
              <td class="muted">{{ $l->mac }}</td>
              <td>{{ bb_format_bytes($l->bytes_in) }}</td>
              <td>{{ bb_format_bytes($l->bytes_out) }}</td>
              <td>{{ $l->login_by }}</td>
            </tr>
          @endforeach
          </tbody>
        </table>
      </div>
    @else
      <div class="muted">No history yet. Open the Active page a few times to start logging.</div>
    @endif
  </div>
@endsection