@extends('layouts.app')
@section('title','Freelancer '.$freelancer->name.' — BlueBando v3')

@section('content')
  <div style="margin-bottom:12px;display:flex;justify-content:space-between;align-items:flex-end;gap:10px">
    <div>
      <h1 style="margin:0 0 4px">{{ $freelancer->name }}</h1>
      <div class="muted">Freelancer profile & recent sales.</div>
    </div>
    <a href="{{ route('freelancers.edit',$freelancer) }}" class="btn-ghost">Edit</a>
  </div>

  <div class="cards" style="margin-bottom:16px">
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="phone" :size="20" /></div>
        <div>
          <div class="label">Phone</div>
          <div class="value" style="font-size:16px">{{ $freelancer->phone }}</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="badge-check" :size="20" /></div>
        <div>
          <div class="label">Commission Rate</div>
          <div class="value">{{ $freelancer->commission_rate }}%</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="currency-dollar" :size="20" /></div>
        <div>
          <div class="label">Recent Sales (last 20)</div>
          <div class="value">{{ number_format($totalSales) }} TZS</div>
        </div>
      </div>
    </div>
    <div class="card">
      <div class="kpi">
        <div class="icon"><x-ico name="receipt-percent" :size="20" /></div>
        <div>
          <div class="label">Commission (est.)</div>
          <div class="value">{{ number_format($commission) }} TZS</div>
        </div>
      </div>
    </div>
  </div>

  <div class="card full" style="margin-bottom:16px">
    <h3 style="margin:0 0 8px;font-size:15px">Routers</h3>
    <div class="muted" style="font-size:13px">
      @forelse($freelancer->routers as $r)
        <div>• {{ $r->name }} ({{ $r->site }})</div>
      @empty
        <div>No routers assigned.</div>
      @endforelse
    </div>
  </div>

  <div class="card full">
    <h3 style="margin:0 0 8px;font-size:15px">Recent Successful Orders</h3>
    <table>
      <thead>
      <tr>
        <th>Ref</th>
        <th>Plan</th>
        <th>Router</th>
        <th>Phone</th>
        <th>Amount</th>
        <th>Date</th>
      </tr>
      </thead>
      <tbody>
      @forelse($orders as $o)
        <tr>
          <td>{{ $o->reference }}</td>
          <td>{{ $o->plan->name ?? '—' }}</td>
          <td>{{ $o->router->name ?? '—' }}</td>
          <td>{{ $o->phone }}</td>
          <td>{{ number_format($o->amount) }} {{ $o->currency }}</td>
          <td class="muted">{{ $o->created_at->format('Y-m-d H:i') }}</td>
        </tr>
      @empty
        <tr><td colspan="6" class="muted">No successful orders yet.</td></tr>
      @endforelse
      </tbody>
    </table>
  </div>
@endsection
