@extends('layouts.app')
@section('title','Add Freelancer — BlueBando v3')

@section('content')
  <h1 style="margin:0 0 10px">Add Freelancer</h1>

  <div class="card full">
    <form method="POST" action="{{ route('freelancers.store') }}">
      @csrf

      <div style="display:grid;grid-template-columns:repeat(2,1fr);gap:14px">
        <div>
          <label class="label">Name</label>
          <input class="input" name="name" value="{{ old('name') }}" required>
        </div>

        <div>
          <label class="label">Phone</label>
          <input class="input" name="phone" value="{{ old('phone') }}" required>
        </div>

        <div>
          <label class="label">Email (optional)</label>
          <input class="input" name="email" value="{{ old('email') }}">
        </div>

        <div>
          <label class="label">Code / Agent ID</label>
          <input class="input" name="code" value="{{ old('code') }}" placeholder="e.g. BB-AGENT-01">
        </div>

        <div>
          <label class="label">Commission Rate (%)</label>
          <input class="input" type="number" step="0.01" name="commission_rate"
                 value="{{ old('commission_rate', 10) }}" required>
        </div>

        <div>
          <label class="label">Status</label>
          <select class="input" name="status">
            <option value="active" @selected(old('status','active')==='active')>Active</option>
            <option value="suspended" @selected(old('status')==='suspended')>Suspended</option>
          </select>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Linked User Account (login)</label>
          <select class="input" name="user_id">
            <option value="">-- Select existing user for login --</option>
            @foreach($users as $u)
              <option value="{{ $u->id }}" @selected(old('user_id')==$u->id)>
                {{ $u->name }} ({{ $u->email }})
              </option>
            @endforeach
          </select>
          <div class="muted" style="font-size:12px;margin-top:4px">
            This user will use <strong>/login</strong> to access the Freelancer Portal.
            Create the user first under <em>Users & Roles</em>.
          </div>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Assigned Routers</label>
          <div style="display:flex;flex-wrap:wrap;gap:8px">
            @foreach($routers as $r)
              <label style="font-size:13px">
                <input type="checkbox" name="router_ids[]"
                       value="{{ $r->id }}" {{ in_array($r->id, old('router_ids',[])) ? 'checked' : '' }}>
                {{ $r->name }} ({{ $r->site }})
              </label>
            @endforeach
          </div>
        </div>

        <div style="grid-column:1/-1">
          <label class="label">Notes</label>
          <textarea class="input" name="notes" rows="3">{{ old('notes') }}</textarea>
        </div>
      </div>

      <div style="margin-top:14px;display:flex;justify-content:flex-end;gap:8px">
        <a href="{{ route('freelancers.index') }}" class="btn-ghost" style="text-decoration:none">Cancel</a>
        <button class="btn">Save Freelancer</button>
      </div>
    </form>
  </div>
@endsection
