<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use App\Models\{Company, User};
use Illuminate\Support\Facades\Hash;

class OwnerSeeder extends Seeder
{
    public function run(): void
    {
        $co = Company::firstOrCreate(['name'=>'BlueBando'], ['brand'=>'BlueBando WiFi']);
        $u  = User::firstOrCreate(['email'=>'owner@blue.local'], [
            'name'=>'Owner',
            'password'=>Hash::make('password'),
            'company_id'=>$co->id
        ]);
        if (method_exists($u, 'assignRole')) $u->assignRole('owner');
    }
}
