<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
{
    Schema::create('sms_logs', function (Blueprint $table) {
        $table->id();
        $table->string('provider'); // 'beem', 'twilio', etc.
        $table->string('to', 20);
        $table->string('sender')->nullable();
        $table->text('message');
        $table->enum('status', ['queued','sent','failed'])->default('queued');
        $table->string('provider_id')->nullable();
        $table->json('payload')->nullable();
        $table->timestamps();
    });
}

public function down(): void
{
    Schema::dropIfExists('sms_logs');
}

};
