<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('payments', function (Blueprint $table) {
        $table->id();
        $table->string('gateway'); // 'azampay', 'selcom', etc.
        $table->string('reference')->unique(); // internal ref
        $table->string('gateway_reference')->nullable(); // azampay merchant reference / transaction id

        $table->string('customer_msisdn', 20)->nullable();
        $table->unsignedInteger('amount');
        $table->string('currency', 10)->default('TZS');

        $table->enum('status', ['pending','processing','success','failed','cancelled'])
              ->default('pending');

        $table->foreignId('router_id')->nullable()->constrained()->nullOnDelete();
        $table->foreignId('plan_id')->nullable()->constrained()->nullOnDelete();
        $table->foreignId('voucher_id')->nullable()->constrained()->nullOnDelete();

        $table->timestamp('paid_at')->nullable();
        $table->json('request_payload')->nullable();
        $table->json('response_payload')->nullable();
        $table->json('callback_payload')->nullable();

        $table->timestamps();
    });
}

public function down(): void
{
    Schema::dropIfExists('payments');
}

};
