<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('openvpn_servers', function (Blueprint $t) {
            $t->id();
            $t->string('name');                 // e.g. "BB-VPS-1"
            $t->string('host');                 // ip / fqdn
            $t->unsignedSmallInteger('port')->default(22);
            $t->string('username')->default('root');
            $t->text('auth_type')->default('password'); // password|key
            $t->text('password')->nullable();   // store encrypted in app
            $t->text('private_key')->nullable();// PEM if using key
            $t->string('ovpn_root')->default('/etc/openvpn'); // where server.conf, easy-rsa etc live
            $t->string('ccd_dir')->default('/etc/openvpn/ccd');
            $t->string('net_cidr')->default('10.8.0.0/24'); // VPN subnet
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('openvpn_servers'); }
};
