<?php
namespace App\Services\Sms;

use Illuminate\Support\Facades\Http;

class TwilioGateway implements SmsGateway
{
    public function send(string $to, string $message, array $meta=[]): SmsResult
    {
        $sid = env('SMS_TWILIO_SID'); $token = env('SMS_TWILIO_TOKEN');
        $from = $meta['from'] ?? '+15005550006';
        $resp = Http::withBasicAuth($sid, $token)
            ->asForm()->post("https://api.twilio.com/2010-04-01/Accounts/{$sid}/Messages.json", [
                'From'=>$from, 'To'=>$to, 'Body'=>$message
            ]);
        return new SmsResult($resp->successful(), $resp->json());
    }
}
